/**
 * 
 */
package gov.va.med.mhv.phrmgr.jms;

import gov.va.med.mhv.integration.phr.service.QueryService;
import gov.va.med.mhv.integration.phr.service.QueryServiceResponse;
import gov.va.med.mhv.integration.phr.service.RefreshDataService;
import gov.va.med.mhv.integration.phr.service.ServiceResponse;
import gov.va.med.mhv.integration.phr.service.StagingService;
import gov.va.med.mhv.integration.phr.stage.enumeration.StageExtractStatusType;
import gov.va.med.mhv.integration.phr.stage.enumeration.StageMessageType;
import gov.va.med.mhv.integration.phr.stage.enumeration.StageRoutingStatusType;
import gov.va.med.mhv.integration.phr.stage.transfer.StageMessageControl;
import gov.va.med.mhv.integration.phr.transfer.QueryRequest;

import java.util.Date;

import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsTemplate;

/**
 * @author DNS
 * 
 */
public class JmsQueryService implements QueryService {

	private JmsTemplate destination;
	
	private StagingService stagingService;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.mhv.integration.phr.service.QueryService#process(gov.va.med
	 * .mhv.integration.phr.transfer.QueryRequest)
	 */
	public QueryServiceResponse process(QueryRequest request) {
		
		QueryServiceResponse response = new QueryServiceResponse(ServiceResponse.NEW);
		StageMessageControl stageMessageControl = new StageMessageControl(
				RefreshDataService.messageName, 
				0L, 								// no valid record count yet. 
				StageRoutingStatusType.NEW, 
				StageMessageType.REQUEST , 
				request.getIcn(), 
				request.getStationNumber(), 
				request.getExtractType(), 
				new Date(), 						// start date / time of now
				null);								// end date of null for now
		
		try {
			this.stagingService.stageRequest(stageMessageControl);
			request.setRequestMsgCtrlId(stageMessageControl.getId());
			this.destination.convertAndSend(request);
		} catch (JmsException jmse) {
			stageMessageControl.setExtractStatus(StageExtractStatusType.ERROR);
			stageMessageControl.setErrorMessage(jmse.getMessage());
			this.stagingService.stageRequest(stageMessageControl);
			response.setStatus(ServiceResponse.ERROR);
			response.setDescription(jmse.getMessage());
			
		}

		return response;
	}

	public void setDestination(JmsTemplate destination) {
		this.destination = destination;
	}
	
	public void setStagingService(StagingService stagingService) {
		this.stagingService = stagingService;
	}
}
